-- PostgreSQL DDL
-- create table script

\connect pcweek

----------
-- create data tables

-- uniques

create table uniques (
u_key	int	not null,
u_int	int	not null,
u_signed	int,
u_float	float4	not null,
u_double	float8	not null,
u_decim	numeric (18,4)	not null,
u_date	date	not null,
u_code	char(10)	not null,
u_name	char(20)	not null,
u_address	varchar(80)	not null,
constraint uniques_key_PK_IDX primary key (u_key)
);

-- hundred

create table hundred (
h_key	int	not null,
h_int	int	not null,
h_signed	int,
h_float	float4	not null,
h_double	float8	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null,
constraint hundred_key_PK_IDX primary key (h_key)
);

-- tenpct

create table tenpct (
t_key	int	not null,
t_int	int	not null,
t_signed	int,
t_float	float4	not null,
t_double	float8	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null,
constraint tenpct_key_code_PK_IDX primary key (t_key, t_code)
);

-- updates

create table updates (
p_key	int	not null,
p_int	int	not null,
p_signed	int,
p_float	float4	not null,
p_double	float8	not null,
p_decim	numeric (18,4)	not null,
p_date	date	not null,
p_code	char(10)	not null,
p_name	char(20)	not null,
p_address	varchar(80)	not null,
constraint updates_key_PK_IDX primary key (p_key)
);

-------------------------

-- tenthou

create table tenthou (
t_key	int	not null,
t_int	int	not null,
t_signed	int,
t_float	float4	not null,
t_double	float8	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null,
constraint tenthou_key_PK_IDX primary key (t_key, t_code)
);

-- hunthou

create table hunthou (
h_key	int	not null,
h_int	int	not null,
h_signed	int,
h_float	float4	not null,
h_double	float8	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null
);

-- twomill

create table twomill (
p_key	int	not null,
p_int	int	not null,
p_signed	int,
p_float	float4	not null,
p_double	float8	not null,
p_decim	numeric (18,4)	not null,
p_date	date	not null,
p_code	char(10)	not null,
p_name	char(20)	not null,
p_address	varchar(80)	not null,
constraint twomill_key_PK_IDX primary key (p_key)
);

-- threemill

create table threemill (
t_key	int	not null,
t_int	int	not null,
t_signed	int,
t_float	float4	not null,
t_double	float8	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null,
constraint threemill_key_PK_IDX primary key (t_key)
);

-- fourmill

create table fourmill (
t_key	int	not null,
t_int	int	not null,
t_signed	int,
t_float	float4	not null,
t_double	float8	not null,
t_decim	numeric (18,4)	not null,
t_date	date	not null,
t_code	char(10)	not null,
t_name	char(20)	not null,
t_address	varchar(80)	not null,
constraint fourmill_key_PK_IDX primary key (t_key)
);

-- fivemill

create table fivemill (
h_key	int	not null,
h_int	int	not null,
h_signed	int,
h_float	float4	not null,
h_double	float8	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null,
constraint fivemill_key_PK_IDX primary key (h_key)
);

-- fourram

create table fourram (
p_key	int	not null,
p_int	int	not null,
p_signed	int,
p_float	float4	not null,
p_double	float8	not null,
p_decim	numeric (18,4)	not null,
p_date	date	not null,
p_code	char(10)	not null,
p_name	char(20)	not null,
p_address	varchar(80)	not null,
constraint fourram_key_PK_IDX primary key (p_key)
);

-- reportview

create view reportview as
	select updates.p_key as r_key, updates.p_signed as r_signed, updates.p_date as r_date, updates.p_decim as r_decim, hundred.h_name as r_name, hundred.h_code as r_code, hundred.h_int as r_int
	from updates, hundred
		where updates.p_key = hundred.h_key;

----------
-- create housekeeping tables

-- update_int_history

create table update_int_history (
p_key	int not null,
p_int	int not null,
p_date datetime not null,
constraint up_int_hist_key_int_PK_IDX primary key (p_key, p_int)
);

-- oltp_write_01_check_value

create table oltp_write_01_check_value (
int_sum float not null
);

-- update_signed_history

create table update_signed_history (
p_key	int	not null,
p_signed	int not null,
p_date datetime not null,
constraint up_sign_hist_key_sign_PK_IDX primary key (p_key, p_signed)
);

-- del_history

create table del_history (
h_key	int	not null,
h_int	int	not null,
h_signed	int,
h_float	float4	not null,
h_double	float8	not null,
h_decim	numeric (18,4)	not null,
h_date	date	not null,
h_code	char(10)	not null,
h_name	char(20)	not null,
h_address	varchar(80)	not null,
constraint del_history_key_PK_IDX primary key (h_key)
);

-- oltp_write_04_count_updates
create table oltp_write_04_count_updates (
num_updates int not null
);

-- end
\q
